<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\Quotation;

class QuotationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;
    public $id;
    /**
     * Create a new message instance.
     */
    public function __construct($id)
    {
        $this->id = $id;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
{
    
    $id = $this->$id ; 
    $quotation = Quotation::where('id', $id)->first();
    
    $tour_type = $quotation->tour_type;
    $subject = ''; 

    if ($tour_type == 't-package') {
        $subject .= 'Your Tailored Day Excursion Quote Inside - ' . $quotation->vehicle;
    } else {
        $subject .= 'Your Customized Tour Quotation - ' . $quotation->vehicle;
    }
    
    return new Envelope(
        subject: $subject,
    );
}


    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.quotation',
        );
    }

    

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}